<?php
/**
 * Author:          Bogdan Preda <bogdan.preda@themeisle.com>
 * Created on:      2021-10-22
 *
 * @package Neve Pro
 */

namespace Neve_Pro\Modules\Post_Type_Enhancements;

use Neve_Pro\Core\Abstract_Module;
use Neve_Pro\Modules\Post_Type_Enhancements\Customizer\Blog_Pro_CPT;
use Neve_Pro\Modules\Post_Type_Enhancements\Customizer\Layout_CPT_Archive;
use Neve_Pro\Modules\Post_Type_Enhancements\Customizer\Layout_CPT_Sidebar_Container;
use Neve_Pro\Modules\Post_Type_Enhancements\Customizer\Layout_CPT_Single;
use Neve_Pro\Modules\Post_Type_Enhancements\Model\CPT_Model;
use Neve_Pro\Modules\Post_Type_Enhancements\Views\Blog_Pro_CPT_View;
use Neve_Pro\Modules\Post_Type_Enhancements\Views\Layout_CPT_Archive_View;
use Neve_Pro\Modules\Post_Type_Enhancements\Views\Layout_CPT_View;

/**
 * Class Module  - main class for the module
 *
 * @package Neve_Pro\Modules\Post_Type_Enhancements
 */
class Module extends Abstract_Module {

	/**
	 * Define module properties.
	 *
	 * @access  public
	 * @return void
	 *
	 * @version 3.0.7
	 */
	final public function define_module_properties() {
		$this->slug          = 'post_type_enhancements';
		$this->name          = __( 'Post types enhancements', 'neve' );
		$this->description   = __( 'Enable Neve post enhancements for custom post types.', 'neve' );
		$this->documentation = array(
			'url'   => 'https://bit.ly/nv-pte',
			'label' => __( 'Learn more', 'neve' ),
		);
		$this->order         = 4;
	}

	/**
	 * Check if module should load.
	 *
	 * @return bool
	 */
	final public function should_load() {
		return $this->is_active();
	}

	/**
	 * Run Post Type Enhancements Module
	 */
	final public function run_module() {
		add_action(
			'init',
			function () {
				$supported_custom_post_types = apply_filters( 'neve_post_type_supported_list', [], 'block_editor' );
				foreach ( $supported_custom_post_types as $order => $custom_post_type ) {
					$model = new CPT_Model( $custom_post_type );
					if ( $model->can_use_model() ) {
						new Layout_CPT_Sidebar_Container( $model );
						new Layout_CPT_Single( $model );
						new Layout_CPT_View( $model );
						new Layout_CPT_Archive( $model );
						new Layout_CPT_Archive_View( $model );

						if ( get_option( 'nv_pro_blog_pro_status' ) ) {
							new Blog_Pro_CPT( $model );
							new Blog_Pro_CPT_View( $model );
						}
					}
				}
			},
			PHP_INT_MAX
		);
	}
}
