<?php
/*
Plugin Name: _Personalização UseFlix - categorias
Plugin URI: 
Description: Personalizações de Categorias na página Single, e pré-seleciona _Assinantes_Pagos nos posts
Version: 0.1
Author: Gilberto Soares Filho
Author URI: 
*/





##
## Funções de interface de postagem
##
## - esconde a página de postagem até estar toda carregada, via CSS - tela_de_espera_postagem()
## - habilita o toggle nas categorias assinatura e tipo - toggle_de_categorias()
## - exibe tudo no document ready - toggle_de_categorias()
##


function tela_de_espera_postagem() {
	
	echo <<<EOF
	
<div id="upmostFlix">	<div class="loader">	<div class="inner one"></div>
  <div class="inner two"></div>
  <div class="inner three"></div>	</div></div>

<style type="text/css">
#upmostFlix{
	display: block;
	position: fixed;
    width: 100%;
    height: 100%;
    background-color: #edecec;
    z-index: 10000;
}

.upmostCenter {
    position: absolute;
    width: 76px;
    height: 76px;
    margin-left: -198px; /* margin is -0.5 * dimension */
    margin-top: -68px; 
    color: #fff;
}

.loader {
  position: absolute;
  top: calc(50% - 32px);
  left: calc(50% - 32px);
  width: 96px;
  height: 96px;
  margin-left: -148px; /* margin is -0.5 * dimension */
  margin-top: -48px; 
  border-radius: 50%;
  perspective: 800px;
}

.inner {
  position: absolute;
  box-sizing: border-box;
  width: 100%;
  height: 100%;
  border-radius: 50%;  
}

.inner.one {
  left: 0%;
  top: 0%;
  animation: rotate-one 1s linear infinite;
  border-bottom: 4px solid #9d9fa0;
}

.inner.two {
  right: 0%;
  top: 0%;
  animation: rotate-two 1s linear infinite;
  border-right: 4px solid #4b6270;
}

.inner.three {
  right: 0%;
  bottom: 0%;
  animation: rotate-three 1s linear infinite;
  border-top: 4px solid #16303f;
}

@keyframes rotate-one {
  0% {
    transform: rotateX(35deg) rotateY(-45deg) rotateZ(0deg);
  }
  100% {
    transform: rotateX(35deg) rotateY(-45deg) rotateZ(360deg);
  }
}

@keyframes rotate-two {
  0% {
    transform: rotateX(50deg) rotateY(10deg) rotateZ(0deg);
  }
  100% {
    transform: rotateX(50deg) rotateY(10deg) rotateZ(360deg);
  }
}

@keyframes rotate-three {
  0% {
    transform: rotateX(35deg) rotateY(55deg) rotateZ(0deg);
  }
  100% {
    transform: rotateX(35deg) rotateY(55deg) rotateZ(360deg);
  }
}
</style>

EOF;


}

if ( $_SERVER['REQUEST_URI'] == "/wp-admin/post-new.php" ) {
	add_action( 'wp_after_admin_bar_render', 'tela_de_espera_postagem' );
}
 


function toggle_de_categorias(){
	
$whoAmI = get_current_user_id();

if ( $whoAmI != 1 ){
	$disableElements = '
	$( "#elementor-switch-mode" ).remove();
	$( "#pmpro_page_meta" ).hide();
	
	';
}

	echo <<<EOF
<style type="text/css">
#acf-group_62bb4bc3da2d7 > div.inside.acf-fields.-top > div.acf-field.acf-field-message.acf-field-62c4467c339a8 > div.acf-label > label, #acf-group_62c58d337ae02 > div.inside.acf-fields.-top > div.acf-field.acf-field-message.acf-field-62c58d433277a > div.acf-label > label { font-size: 1.5em; margin-bottom: -15px!important; }
</style>

<script type="text/javascript">
	jQuery(document).ready(function( $ ) {

		$disableElements
		
		$( "#pageparentdiv" ).hide(); 
		$( "#neve-page-settings" ).hide(); 
		$( "#rocket_post_exclude" ).hide();
		$( "#category-add-toggle" ).hide();
		$( "#categorychecklist-pop" ).html("Utilizar a estrutura padrão de categorias, na aba \"Todas as Categorias\"");
		
		$( '.categorydiv input').on('click', function(){
			var estaCategoria = $(this).val();
			if ( estaCategoria >= 49 && estaCategoria <= 52 ){
			
				$( '#category-9 input' ).prop( "checked", false );
				$( '#category-9 .children input' ).prop( "checked", false );
				$( '#category-14 input' ).prop( "checked", false );
				$( '#category-14 .children input' ).prop( "checked", false );
				$( '#category-21 input' ).prop( "checked", false );
				$( '#category-21 .children input' ).prop( "checked", false );
				$( '#category-27 input' ).prop( "checked", false );
				$( '#category-27 .children input' ).prop( "checked", false );

				$( "#category-9, #category-14, #category-21, #category-27" ).hide();
			}
			
			
			if ( estaCategoria >= 38 && estaCategoria <=40 ){
					
				$( "#in-category-38" ).prop( "checked", false );
				$( "#in-category-39" ).prop( "checked", false );
				$( "#in-category-40" ).prop( "checked", false );
				$( "#in-category-"+estaCategoria ).prop( "checked", true );
				
			}
		});
		
		
		$( "#category-21 .children input" ).on('click', function(){
			
			var estaCategoria = $(this).val();
			$( "#category-21 .children input" ).prop( "checked", false );
			$( "#category-"+estaCategoria+" input" ).prop( "checked", true);
			
		});

			/*$('#categorydiv').animate({opacity: 1});*/
			/*$('#postbox-container-1').animate({opacity: 1});    */
			$( "#in-category-22" ).prop( "checked", true );
			$('#upmostFlix').animate({opacity: 0}).css({'z-index' : '-99999'}); 

	});


</script>
EOF;

}

add_action('admin_footer', 'toggle_de_categorias');


/*Função para preselecionar a categoria _asssinante como marcada*/
function WPSE_pre_select_categories($args, $post_id) {
        $post = get_post($post_id);

        // only pre select categories for new posts
        if ($post->post_status !== 'auto-draft' || $post->post_type !== 'post')
                return $args;

        // select categories with ID 4 and 6
        $select_categories = [40];

        // little hack so array_merge() works if default is NULL
        if (empty($args['selected_cats'])) {
                $args['selected_cats'] = [];
        }

        // array_merge() with numerical indices only appends
        // so I use array_unique() to remove any duplicates
        $args['selected_cats'] = array_unique(array_merge($args['selected_cats'], $select_categories));
        return $args;
}

add_filter('wp_terms_checklist_args', 'WPSE_pre_select_categories', 10, 2);


?>